﻿Public Class Form1
    'デザインでの作業は以下の通り
    'ツールボックスからTimerを選び一つ配置する
    'TimerのEnabledプロパティをTrueに、Intervalプロパティを20に設定する
    'Formの DoubleBuffer プロパティを True にする（描画時のちらつきを防止するため）

    '描画する線の本数
    Const 本数 As Integer = 50
    '描画する線の始点と終点を格納する配列変数
    Dim x1(本数), y1(本数), x2(本数), y2(本数) As Integer
    '先頭の線の始点と終点の速度
    Dim 速度x1, 速度y1, 速度x2, 速度y2 As Integer
    '線の色
    Dim r, g, b As Integer

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim i As Integer
        '乱数を初期化する
        Randomize()
        '最初の位置を設定（最初はすべての線を同じ位置にする）
        For i = 1 To 本数
            x1(i) = 100
            y1(i) = 100
            x2(i) = 50
            y2(i) = 50
        Next
        '最初の速度を設定
        速度x1 = 20
        速度y1 = 10
        速度x2 = -10
        速度y2 = -20
        ' 色を設定
        r = Rnd() * 256
        g = Rnd() * 256
        b = Rnd() * 256
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim i As Integer

        '線の位置の情報を、後ろから順番に一つ前の位置をコピーする
        For i = 本数 To 2 Step -1
            x1(i) = x1(i - 1)
            y1(i) = y1(i - 1)
            x2(i) = x2(i - 1)
            y2(i) = y2(i - 1)
        Next

        '先頭の線を動かす処理
        '線の始点の動きの計算
        '左右の反射のチェック ウィンドウの枠の幅(18ドット)の分補正する
        If x1(1) + 速度x1 > Me.Width - 18 Or x1(1) + 速度x1 < 0 Then
            速度x1 = -速度x1
        End If
        '上下の反射のチェック ウィンドウの枠やタイトルバーの幅(50ドット)の分補正する
        If y1(1) + 速度y1 > Me.Height - 50 Or y1(1) + 速度y1 < 0 Then
            速度y1 = -速度y1
        End If
        ' 位置を速度の分だけずらす
        x1(1) = x1(1) + 速度x1
        y1(1) = y1(1) + 速度y1

        '線の終点の動きの計算
        If x2(1) + 速度x2 > Me.Width - 18 Or x2(1) + 速度x2 < 0 Then
            速度x2 = -速度x2
        End If
        If y2(1) + 速度y2 > Me.Height - 50 Or y2(1) + 速度y2 < 0 Then
            速度y2 = -速度y2
        End If

        x2(1) = x2(1) + 速度x2
        y2(1) = y2(1) + 速度y2

        '描画する（Paintイベントを発生させる。実際の描画は下の Form1_Paint で行われる）
        Invalidate()

    End Sub

    Private Sub Form1_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDown
        ' クリックで色をランダムに変更する
        r = Rnd() * 256
        g = Rnd() * 256
        b = Rnd() * 256
    End Sub

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        '補足：Formの DoubleBuffer プロパティを True にすることでちらつきを防止することができる
        Dim ペン As Pen
        '色の設定
        ペン = New Pen(Color.FromArgb(r, g, b))
        '本数分だけ描画する
        For i = 1 To 本数
            e.Graphics.DrawLine(ペン, x1(i), y1(i), x2(i), x2(i))
        Next
    End Sub
End Class
